//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.17 Page 431
//Title: Heat loss and reduction of heat loss
//======================================================

model Ex10_17
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=298 " Temperature of surface";
parameter Real T2(unit="K")=275 " Ambient Temperature";
parameter Real A1(unit="m^2")=8 " Area";
parameter Real e1(unit="")=0.9 "Emissivity";
parameter Real e2(unit="")=0.5 "Emissivity";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit="kW")" Heat lost";
Real Qred(unit="kW")" Reduction in Heat lost";

//=============
// Equation Section

equation

Q=sigma*A1*e1*((T1^4)-(T2^4))/1000;
Qred=(e1-e2)*Q/e1;

end Ex10_17;
//======================================================
