//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.22 Page 445
//Title: Net heat transfer
//======================================================

model Ex10_22
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=1173 " Temperature of first plate";
parameter Real T2(unit="K")=673 " Temperature of second plate";
parameter Real T3(unit="K")=300 " Temperature of walls";
parameter Real e1(unit="")=0.2 " Emissivity of first plate";
parameter Real e2(unit="")=0.5 " Emissivity of second plate";
parameter Real A(unit="m^2")=1 " Area";
parameter Real F12(unit="")=0.415 " Shape Factor"; //Obtained from Fig10.4 on pg409
parameter Real J1(unit="kW/m^2")=25 " Radiosity 1";
parameter Real J2(unit="kW/m^2")=11.6 " Radiosity 2";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real F13(unit="") " Shape Factor";
Real F23(unit="") " Shape Factor";
Real Eb1(unit="kW/m^2") " Emissivity 1";
Real Eb2(unit="kW/m^2") " Emissivity 2";
Real Eb3(unit="kW/m^2") " Emissivity 3";
Real R1(unit="m^-2") " Resistance 1";
Real R2(unit="m^-2") " Resistance 2";
Real A1F12(unit="m^-2") " Reciprocal of product of shape factor and area";
Real A1F13(unit="m^-2") " Reciprocal of product of shape factor and area";
Real A2F23(unit="m^-2") " Reciprocal of product of shape factor and area";
Real Q1(unit="kW")" Heat lost by first plate";
Real Q2(unit="kW")" Heat lost by second plate";
Real Q3(unit="kW")" Heat received by room";

//=============
// Equation Section

equation

Eb1=sigma*(T1^4)/1000;
Eb2=sigma*(T2^4)/1000;
Eb3=sigma*(T3^4)/1000;
R1=(1-e1)/(e1*A);
R2=(1-e2)/(e2*A);
A1F12=1/(A*F12);
A1F13=1/(A*F13);
A2F23=1/(A*F23);
F23=1-F12;
F13=1-F12;
Q1=(Eb1-J1)/R1;
Q2=(Eb2-J2)/R2;
Q3=((J1-Eb3)/A1F13) + ((J2-Eb3)/A2F23);

//Deviation in answer of Q2 arises due to truncation.

end Ex10_22;
//======================================================
