//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-11: Boiling and Condensation
//Example: 11.1 Page 480
//Title: Temperature of bottom surface of pan
//======================================================

model Ex11_1
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real m(unit = "kg/hr ") = 30  " Boiling rate ";
parameter Real d(unit = "m ") =30e-2   " Diameter of pan "; 

//Properties of water at atmospheric pressure
parameter Real Tsat(unit = "C") =100 " Temperature saturated ";
parameter Real den[2](unit = "kg/m^3") ={957.9,0.5955}" Density of liquid and vapour respectively ";
parameter Real ul(unit = "Pa s") =279e-6 " Viscosity of water ";
parameter Real Pr(unit = "") =1.76 " Prandtl number ";
parameter Real h(unit = "J/kg") =2257e3 " Enthalpy of vapourisation ";
parameter Real sigma(unit = "N/m") =58.9e-3 " Surface Tension of liquid vapour interface ";
parameter Real Cp(unit = "J/kg K") =4217 " Specific Heat of water ";
parameter Real Cs(unit = "") =0.013 " Constant from table 11.1 ";

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section
Real qs(unit= "W/m^2") " Heat Transfer Rate ";
Real Te(unit= "C") " Change in temperature ";
Real Ts(unit= "C") " Surface temperature ";

//=============
// Equation Section

equation

qs=m*h/(3600*pi*d*d/4);

Te=((qs/(h*ul))*(sigma/(g_n*(den[1]-den[2])))^(0.5))^(1/3)  * (Cs*h*(Pr^1.7))/Cp;

Ts=100+Te;

end Ex11_1;
//======================================================
