//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-11: Boiling and Condensation
//Example: 11.6 Page 489
//Title: Thickness of the condensate film
//======================================================

model Ex11_6
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real P(unit = " atm") =2.45 " Pressure given ";
parameter Real T(unit = " C ") = 117 " Surface temperature ";
parameter Real h(unit = " m ") = 1 " Height of tube "; 
parameter Real x(unit = " m ") = 0.2 " Distance from upper end of tube "; 

//Properties of water at 2.45 bar
//Saturated Vapour
parameter Real Tsat(unit = "C") =127 " Temperature saturated ";
parameter Real pv(unit = "kg/m^3" )=1.368 " Density of steam ";
parameter Real hfg(unit = "kJ/kg" )=2183 " Enthalpy of steam ";

//Saturated Water at Film Temperature of 122 degree celsius
parameter Real pl(unit = "kg/m^3" )=941.6 " Density of water ";
parameter Real ul(unit = "Pa s" )=227e-6 " Viscosity of water ";
parameter Real kl(unit = "W/m K" )=687e-3 " Thermal Conductivity of water ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real hx(unit= "W/m^2 K") " Local Heat transfer coefficient ";
Real d(unit= "m") " Thickness of condensate film ";

//=============
// Equation Section

equation

d=( (4*kl*ul*(Tsat-T)*x) / (g_n*pl*(pl-pv)*hfg*1e3) )^0.25;
hx=kl/d;

end Ex11_6;
//======================================================
