//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.10 Page 517
//Title: Surface Area of heat exchanger in crossflow 
//======================================================

model Ex12_10
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Th[2](unit = " C ") = {360,300} " Oil inlet and outlet temperatures respectively ";
parameter Real Ch(unit = " W/ K ") = 2500 " Oil heat capacity";
parameter Real U(unit = " W/ m^2 K ") = 800 " Overall heat transfer coefficient";
parameter Real Tc[2](unit = " C ") = {30,200} " Water inlet and outlet temperatures respectively ";
parameter Real F(unit="")=0.98 "Correction factor referring to Fig 12.11 on pg 515";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real R(unit="") "Temperature Ratio ";
Real P(unit="") "Temperature Ratio ";
Real Q(unit= "W")" Heat transfer rate ";
Real A(unit= "m^2 ")" Area of heat exchanger in parallel and counter flow respectively";
Real Tlmtd(unit = " C ") "Log Mean temperature difference in counter flow respectively";

//=============
// Equation Section

equation

Ch*(Th[1]-Th[2])=Q;
R=(Th[1]-Th[2])/(Tc[2]-Tc[1]);
P=(Tc[2]-Tc[1])/(Th[1]-Tc[1]);
Tlmtd=((Th[1]-Tc[2])-(Th[2]-Tc[1]))/(log((Th[1]-Tc[2])/(Th[2]-Tc[1])));
Q=F*A*U*Tlmtd;

end Ex12_10;
//======================================================
