//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.12 Page 524
//Title: Effectiveness of heat exchanger
//======================================================

model Ex12_12
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Thi(unit = " C ") = 120 " Hot liquid inlet temperature";
parameter Real Tci(unit = " C ") = 10 " Water inlet temperature";
parameter Real mh(unit = " kg/hour ") = 250 " Hot liquid flow rate";
parameter Real mc(unit = " kg/hour ") = 1000 " Water flow rate";
parameter Real cph(unit = " J/kg K ") = 3350 " Hot liquid specific heat capacity";
parameter Real cpc(unit = " J/kg K ") = 4186 " Water specific heat capacity";
parameter Real Uo(unit = " W/ m^2 K ") =1160 " Overall heat transfer coefficient";
parameter Real A(unit ="m^2")=0.25 " Area of heat exchanger";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tho(unit = " C ") " Hot liquid outlet temperature";
Real Tco(unit = " C ") " Water outlet temperature";
Real Ch(unit = " W/K ") " Hot liquid heat capacity";
Real Cc(unit = " W/K ") " Water heat capacity";
Real Cmin(unit = " W/K ") " Minimum heat capacity";
Real Cmax(unit = " W/K ") " Maximum heat capacity";
Real Q(unit= "W")" Actual Heat transfer rate ";
Real Qmax(unit= "W")" Maximum Heat transfer rate ";
Real NTU(unit= "")" Number of transfer units ";
Real E(unit= "")" Effectiveness ";

//=============
// Equation Section

equation

Ch=mh*cph/3600;
Cc=mc*cpc/3600;
Cmin=min(Ch,Cc);
Cmax=max(Ch,Cc);
NTU=Uo*A/Cmin;
E=(1-e^(-NTU*(1+(Cmin/Cmax))))/(1+(Cmin/Cmax));
Qmax=Cmin*(Thi-Tci);
Q=E*Qmax;
Q=Cc*(Tco-Tci);
Q=Ch*(Thi-Tho);

end Ex12_12;
//======================================================
