//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.13 Page 527
//Title: Total heat transfer and outlet temperatures
//======================================================

model Ex12_13
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Thi(unit = " C ") = 94 " Oil inlet temperature";
parameter Real Tci(unit = " C ") = 15 " Cold Water inlet temperature";
parameter Real mh(unit = " kg/hour ") = 550 " Oil flow rate";
parameter Real mc(unit = " kg/hour ") = 1300 " Cold Water flow rate";
parameter Real cph(unit = " J/kg K ") = 2000 " Oil specific heat capacity";
parameter Real cpc(unit = " J/kg K ") = 4186 " Cold Water specific heat capacity";
parameter Real Uo(unit = " W/ m^2 K ") =1075 " Overall heat transfer coefficient";
parameter Real A(unit ="m^2")=1 " Area of heat exchanger";
parameter Real E(unit= "")=0.94 " Effectiveness "; //From fig 12.15 on page 524

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tho(unit = " C ") " Hot oil outlet temperature";
Real Tco(unit = " C ") " Cold Water outlet temperature";
Real Ch(unit = " W/K ") " Hot oil heat capacity";
Real Cc(unit = " W/K ") " Cold Water heat capacity";
Real Cmin(unit = " W/K ") " Minimum heat capacity";
Real Cmax(unit = " W/K ") " Maximum heat capacity";
Real Q(unit= "W")" Actual Heat transfer rate ";
Real Qmax(unit= "W")" Maximum Heat transfer rate ";
Real NTU(unit= "")" Number of transfer units ";

//=============
// Equation Section

equation

Ch=mh*cph/3600;
Cc=mc*cpc/3600;
Cmin=min(Ch,Cc);
Cmax=max(Ch,Cc);
NTU=Uo*A/Cmin;
Qmax=Cmin*(Thi-Tci);
Q=E*Qmax;
Q=Cc*(Tco-Tci);
Q=Ch*(Thi-Tho);

end Ex12_13;
//======================================================
