//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.15 Page 530
//Title: Air and Water outlet temperature
//======================================================

model Ex12_15
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Thi(unit = " C ") = 40 " Air inlet temperature";
parameter Real Tci(unit = " C ") = 5 " Cold Water inlet temperature";
parameter Real mh(unit = " kg/hour ") = 4000 " Air flow rate";
parameter Real mc(unit = " kg/hour ") = 4600 " Cold Water flow rate";
parameter Real cph(unit = " J/kg K ") = 1010 " Air specific heat capacity";
parameter Real cpc(unit = " J/kg K ") = 4186 " Cold Water specific heat capacity";
parameter Real Uo(unit = " W/ m^2 K ") =150 " Overall heat transfer coefficient";
parameter Real A(unit ="m^2")=25 " Area of heat exchanger";
parameter Real E(unit= "")=0.92 " Effectiveness "; //From fig 12.18 on page 526

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tho(unit = " C ") " Hot air outlet temperature";
Real Tco(unit = " C ") " Cold Water outlet temperature";
Real Ch(unit = " W/K ") " Hot air heat capacity";
Real Cc(unit = " W/K ") " Cold Water heat capacity";
Real Cmin(unit = " W/K ") " Minimum heat capacity";
Real Cmax(unit = " W/K ") " Maximum heat capacity";
Real Q(unit= "W")" Actual Heat transfer rate ";
Real NTU(unit= "")" Number of transfer units ";

//=============
// Equation Section

equation

Ch=mh*cph/3600;
Cc=mc*cpc/3600;
Cmin=min(Ch,Cc);
Cmax=max(Ch,Cc);
NTU=Uo*A/Cmin;
Q=E*Cmin*(Thi-Tci);
Q=Cc*(Tco-Tci);
Q=Ch*(Thi-Tho);

end Ex12_15;
//======================================================
