//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.2 Page 504
//Title: Overall Heat Transfer Coefficient with fouling
//======================================================

model Ex12_2
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = " C ") = 80 " Water temperature "; 
parameter Real D[2](unit = " m ") = {2.286e-2,2.54e-2} " Inner and Outer diameters of tube respectively ";
parameter Real k(unit = "W/m C") = 102 " Thermal Conductivity of tube ";
parameter Real ho(unit= "W/m^2 C")=3800 " Heat convection coefficient outside ";
parameter Real hi(unit= "W/m^2 C")=5500 " Heat convection coefficient inside ";
parameter Real R[2](unit= "m^2 W/C")={0.0002,0.0002} " Fouling factors inside and outside";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Uo(unit= "W/m^2 C")" Overall Heat transfer coefficient";

//=============
// Equation Section

equation

(1/Uo)=(1/ho)+R[2]+ ((D[2]/2)*log(D[2]/D[1])/k) + (D[2]/(hi*D[1])) +(R[1]*D[2]/D[1]);//Formula given is incorrect

end Ex12_2;
//======================================================
