//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.7 Page 516
//Title: Effective Log mean temperature difference
//======================================================

model Ex12_7
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Ts(unit = " C ") = 100 "Saturated Steam temperature";
parameter Real Tc[2](unit = " C ") = {30,70} " Water inlet and outlet temperatures respectively ";
parameter Real F(unit="")=1 "Correction factor referring to Fig 12.12 on pg 515";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real R(unit="") "Temperature Ratio ";
Real P(unit="") "Temperature Ratio ";
Real Tlmtd[3](unit = " C ") "Log Mean temperature difference in counter, parallel and cross flow";

//=============
// Equation Section

equation

Tlmtd[1]=((Ts-Tc[2])-(Ts-Tc[1]))/(log((Ts-Tc[2])/(Ts-Tc[1])));
Tlmtd[2]=((Ts-Tc[1])-(Ts-Tc[2]))/(log((Ts-Tc[1])/(Ts-Tc[2])));
R=(Ts-Ts)/(Tc[2]-Tc[1]);
P=(Tc[2]-Tc[1])/(Ts-Tc[1]);
Tlmtd[3]=F*Tlmtd[1];

end Ex12_7;
//======================================================
