//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.8 Page 516
//Title: Area in a shell and tube heat exchanger
//======================================================

model Ex12_8
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Th[2](unit = " C ") = {18,6.5} "Oil inlet and outlet temperatures respectively ";
parameter Real Tc[2](unit = " C ") = {-1.1,2.9} " Water inlet and outlet temperatures respectively ";
parameter Real U(unit = " W/ m^2 K ") = 850 " Overall heat transfer coefficient";
parameter Real Q(unit = " W ") = 6000 " Heat transfer rate";
parameter Real F(unit="")=0.97 "Correction factor referring to Fig 12.9 on pg 514";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real R(unit="") "Temperature Ratio ";
Real P(unit="") "Temperature Ratio ";
Real Tlmtd(unit = " C ") "Log Mean temperature difference in counter flow";
Real A(unit = " m^2 ") "Area of Heat exchanger";

//=============
// Equation Section

equation

Tlmtd=((Th[1]-Tc[2])-(Th[2]-Tc[1]))/(log((Th[1]-Tc[2])/(Th[2]-Tc[1])));
R=(Th[1]-Th[2])/(Tc[2]-Tc[1]);
P=(Tc[2]-Tc[1])/(Th[1]-Tc[1]);
Q=U*F*A*Tlmtd;

end Ex12_8;
//======================================================
