//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-13: Diffusion Mass Transfer
//Example: 13.3 Page 557
//Title: Diffusion flux of helium
//======================================================

model Ex13_3
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real t(unit = "mm") = 1e-3 " Thickness of plastic membrane";
parameter Real CA1(unit = "kmol/m^3") = 0.02 " Concentration in inner surface";
parameter Real CA2(unit = "kmol/m^3") = 0.005 " Concentration in outer surface";
parameter Real DAB(unit= "m^2/s")=1e-9 " Diffusion coefficient ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Nax(unit = " kmol/m^2 s ") " Diffusion flux";

//=============
// Equation Section

equation

Nax=DAB*(CA1-CA2)/t;

end Ex13_3;
//======================================================
