//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-13: Diffusion Mass Transfer
//Example: 13.4 Page 557
//Title: Initial rate of leakage
//======================================================

model Ex13_4
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real t(unit = "m") = 3e-3 " Thickness of silica container";
parameter Real D(unit = "m") = 100e-3 " Diameter of silica container";
parameter Real T(unit = "C") = 25 " Temperature";
parameter Real P(unit = "bar") = 4 " Pressure ";
parameter Real S(unit = "kmol/m^3 bar") = 0.45e-3 " Solubility ";
parameter Real DAB(unit= "m^2/s")=0.4e-13 " Diffusion coefficient ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real dPdt(unit = " bar/ s ") " Initial rate of leakage";

//=============
// Equation Section

equation

dPdt= -6*(0.08316)*(T+273)*S*DAB*P/(t*D);

end Ex13_4;
//======================================================
