//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-13: Diffusion Mass Transfer
//Example: 13.9 Page 569
//Title: Time to elevate carbon content
//======================================================

model Ex13_9
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit = "m") = 1e-3 " Thickness ";
parameter Real D(unit = "m") = 20e-2 " Diameter ";
parameter Real T(unit = "C") = 1000 " Temperature";
parameter Real Cas(unit="")=0.02 "Carbon mole fraction";
parameter Real Ca(unit="")=0.012 "Initial carbon mole fraction";
parameter Real Cao(unit="")=0.004 "Final carbon mole fraction";
parameter Real n(unit= "")=0.48 " Value of eta";//Obtained from error function tables
parameter Real DAB(unit= "m^2/s")=6e-10 " Diffusion coefficient ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real erf(unit= "m^2/s")" Error function value";
Real t(unit= "s")" Time required";

//=============
// Equation Section

equation

erf=(Ca-Cas)/(Cao-Cas);
n=x/(2*((DAB*t)^0.5));

end Ex13_9;
//======================================================
