//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.1 Page 574
//Title:  Convection mass transfer coefficient
//======================================================

model Ex14_1
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real D(unit = "m") = 25e-3 " Diameter ";
parameter Real r(unit = "kg/s") = 2e-6 " Rate of sublimation";
parameter Real Cas(unit="kmol/m^3")=6e-6 " Saturated vapour concentration";
parameter Real M(unit= "kg/kmol")=128 " Moelcular weight of napththalene ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit= "kmol/ms")" Molar transfer rate";
Real hm(unit= "m/s")" Convection mass transfer coefficient";

//=============
// Equation Section

equation

Q=r/M;
Q=hm*pi*D*Cas;

end Ex14_1;
//======================================================
