//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.10 Page 592
//Title: Specific Humidity
//======================================================

model Ex14_10
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T[2](unit="C")={27,17} " Dry and wet bulb temperatures respectively";
parameter Real Cp(unit="kJ/kg K")= 1.004 " Specific heat ";
parameter Real Sc(unit="")=0.6" Schmidt Number ";
parameter Real Pr(unit="")= 0.74" Prandtl Number ";
parameter Real Mv(unit="kg/kmol")=18" Molecular Weight of vapour";
parameter Real Ma(unit="kg/kmol")=29" Molecular Weight of air";
parameter Real P(unit="Pa")=1.0132e5 " Pressure ";
parameter Real Pv(unit="Pa")=1917 " Pressure ";
parameter Real hfg(unit="kJ/kg")=2461 " Latent heat ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Le(unit="")" Lewis Number ";
Real w1(unit="kg/kg of dry air")" Specific humidity of air ";
Real w2(unit="kg/kg of dry air")" Saturated Specific humidity of air ";

//=============
// Equation Section

equation

Le=Pr/Sc;
(w2-w1)/(T[1]-T[2])=(Cp/hfg)*Le^(2/3);
w2=(Mv/Ma)*(Pv/(P-Pv));

end Ex14_10;
//======================================================
