//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.11 Page 592
//Title: Rate of evaporation
//======================================================

model Ex14_11
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = "C") = 27 " Temperature";
parameter Real Ts(unit = "C") = 37 " Saturation Temperature";
parameter Real l(unit = "m") = 15 " Length ";
parameter Real u(unit=" m/s")= 2 " Velocity ";
parameter Real DAB(unit= "m^2/s")=0.26e-4 " Diffusion coefficient ";
parameter Real Psat(unit= "Pa")=3531 " Partial pressure ";
parameter Real Pf(unit= "Pa")=2488.4 " Saturation Partial pressure ";
parameter Real P(unit= "Pa")=101.325e3 " Saturation Partial pressure ";

//Properties of dry air at 300K
parameter Real p1(unit=" kg/m^3")= 0.0436 " Density ";
parameter Real v1(unit="m^2/s")= 15.89e-6 " Kinematic Viscosity ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Sc(unit= "")" Schmidt Number ";
Real Re(unit= "")" Reynolds Number ";
Real Sh(unit= "")" Sherwood Number ";
Real hm(unit= "m/s")" Mass transfer coefficient";
Real p1c[2](unit=" kg/m^3") " Density ";
Real na(unit="kg/m^2 day") " Rate of evaporation";
Real Wl(unit="kg/day") " Water loss";

//=============
// Equation Section

equation

Sc=v1/DAB;
Re=(u*l)/v1;
Sh=(0.037*(Re^0.8)-870)*Sc^(1/3);
hm=Sh*(DAB/l);
p1c[1]=(18*Psat)/(8314*(T+273));
p1c[2]=(18*Pf)/(8314*(Ts+273));
na=hm*(p1c[1]-p1c[2])*86400;
Wl=hm*(p1c[1]-p1c[2])*l*5*3600*24;

end Ex14_11;
//======================================================
