//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.3 Page 583
//Title:  Mass transfer coefficient of Water Vapour
//======================================================

model Ex14_3
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = "C") = 27 " Temperature";
parameter Real P(unit = "atm") = 1 " Pressure ";
parameter Real l(unit = "m") = 50e-2 " Length of plate ";
parameter Real u(unit=" m/s")= 50 " Velocity ";
parameter Real DAB(unit= "m^2/s")=0.26e-4 " Diffusion coefficient ";

//Properties of dry air at 300K
parameter Real p1(unit=" kg/m^3")= 1.16 " Density ";
parameter Real v1(unit="Pa s")= 184.6e-7 " Dynamic Viscosity ";
parameter Real Pr(unit="")= 0.707 " Prandtl Number";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Sc(unit= "")" Schmidt Number ";
Real Re(unit= "")" Reynolds Number ";
Real hm(unit= "m/s")" Mass transfer coefficient";

//=============
// Equation Section

equation

Sc=v1/(p1*DAB);
Re=(p1*u*l)/v1;
0.0296*1*(Re^(-0.2))=(hm/u)*Sc^(2/3);

end Ex14_3;
//======================================================
