//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-14: Convective Mass Transfer
//Example: 14.6 Page 586
//Title: Mass transfer coefficient
//======================================================

model Ex14_6
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = "C") = 25 " Temperature";
parameter Real d(unit = "m") = 3e-2 " Diameter of tube ";
parameter Real u(unit=" m/s")= 5 " Velocity ";
parameter Real DAB(unit= "m^2/s")=0.82e-5 " Diffusion coefficient ";

//Properties of dry air at 298K
parameter Real v1(unit="m^2/s")= 15.7e-6 " Kinematic Viscosity ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Sc(unit= "")" Schmidt Number ";
Real Sh(unit= "")" Sherwood Number ";
Real Re(unit= "")" Reynolds Number ";
Real hm(unit= "m/s")" Mass transfer coefficient";

//=============
// Equation Section

equation

Sc=v1/DAB;
Re=(u*d)/v1;
Sh=0.023*(Re^0.8)*Sc^(1/3);
hm=Sh*(DAB/d);

end Ex14_6;
//======================================================
