//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.17 Page 74
//Title: Heat Transfer in sphere
//======================================================

model Ex3_17
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {300,30}   " Inner and Outer Temperatures ";
parameter Real k[2] (unit = " W/ m K ") ={70,15}   " Respective Thermal Conductivities ";
parameter Real r[3] (unit = " m ") = {0.05,0.15,0.2} " Respective radii from centre ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real Q(unit= "kW") " Heat Transfer Rate ";

//=============
// Equation Section

equation

Q=(4*pi*(T[1]-T[2]))/(1000*( ((r[2]-r[1])/(r[1]*r[2]*k[1])) + ((r[3]-r[2])/(r[3]*r[2]*k[2])) ));

end Ex3_17;
//======================================================
