//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.19 Page 78
//Title: Critical radius in electrical conductivity
//======================================================

model Ex3_19
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {80,20}   " Maximum and Ambient Temperatures ";
parameter Real k[2] (unit = " W/ m K ") = {400,05} "  Thermal Conductivity of Copper and plastic ";
parameter Real h (unit = " W/ m^2 K ") = 8 " Heat Transfer coefficient between air & insulation ";
parameter Real r (unit = " m ") = 0.0005 " Radius of Copper wire ";
parameter Real t (unit = " m ") = 0.001 " Thickness of insulation ";
parameter Real P (unit = " ohm m ") = 3E-8 " Specific Electrical resistance of Copper "; 
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;


//=============
// Variable Section

Real R(unit= " ohm/m ") " Electrical Resistance per unit length ";
Real rc(unit = " m ") " Critical Radius ";
Real I(unit =" A ") " Current ";
Real Rth(unit = "K/W") " Thermal resistance per metre length ";
Real Q(unit = "W") " Heat Transfer rate "; 
//=============
// Equation Section

equation

rc=k[2]/h;
R=P/(pi*(r^2));
Rth= (1/(2*pi*(r+t)*h)) + ((log((t+r)/r))/(2*pi*k[2]));
Q= (T[1]-T[2])/Rth;
I=(Q/R)^0.5;

/*
As the critical radius of insulation is much greater than that provided in the problem, the current carrying capacity of the conductor can be raised considerably in increasing the radius of plastic covering upto 6.2 cm.This may however lead to the problem of having too high a temperature at the cable centre if the temperature inside the plastic coating has to be kept within the given limits.
*/

//Error in value of I and R. I should be 10.8 not 1.08, while R should be 0.032 . This is because r is taken as 0.05mm.  

end Ex3_19;
//======================================================
