//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.21 Page 85
//Title: Surface Temperature of Current Carrying Tube
//======================================================

model Ex3_21
extends Modelica.Math;
//=============
// Parameter Section

parameter Real Tf (unit = " C ") = 30 " Water Temperatures ";
parameter Real k (unit = " W/ m K ") = 18 "  Thermal Conductivity of tube material ";
parameter Real I(unit =" A ") =1000 " Current ";
parameter Real h (unit = " W/ m^2 K ") = 35000 " Heat Transfer coefficient of water side ";
parameter Real d[2] (unit = " m ") = {0.006,0.004} " Outer and Inner Diameters ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
parameter Real Er (unit= "ohm mm^2/m") = 0.1 "Electrical resistivity of the material ";

//=============
// Var[2]able Section

Real r[2] (unit = " m ") " Outer and Inner Radii ";
Real T(unit= " C ") " Surface temperature ";
Real q(unit= " W/m^3 ") " Rate of heat generated ";
Real V(unit="m^3 ") " Volume of the pipe ";
Real Rth(unit = "ohm" ) " Resistance of the pipe";

 
//=============
// Equation Section

equation

r=d./2;
V=pi*((r[1]^2)-(r[2]^2));
Rth=Er/(pi*(r[1]^2-r[2]^2)*(10^6));
q = (I^2)*(Rth/V);
T=Tf+((( q*r[2]*r[2])/(4*k))*((((2*k)/(h*r[2]))-1) *(((r[1]/r[2])^2) -1) +(2*(r[1]/r[2])^2*log(r[1]/r[2]))));


end Ex3_21;
//======================================================
