//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.26 Page 102
//Title: Heat Dissipated in an Aluminium rod
//======================================================

model Ex3_26
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {140,15}   " Wall and Air Temperatures ";
parameter Real d (unit = " m ") = 3*10^(-3) " Diameter of rod ";
parameter Real k (unit = " W/ m K ") = 150 " Thermal Conductivity of the rod ";
parameter Real h (unit = "W/m^2 K ") = 300 " Heat transfer coefficient between surface and air ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real a(unit= "m^2") " Area of the rod ";
Real p(unit= "m") " Perimeter of the rod ";
Real Q(unit= "W") " Heat Dissipated ";

//=============
// Equation Section

equation

a=pi*d*d/4;
p=pi*d;
Q=(h*p*k*a)^0.5 * (T[1]-T[2]);

end Ex3_26;
//======================================================
