//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.27 Page 103
//Title: Thermal Conductivity of the rod
//======================================================

model Ex3_27
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {110,85}   " Temperatures at a gap of 10 cm ";
parameter Real Tair (unit = " C ") = 22  " Air Temperature";
parameter Real d (unit = " m ") = 2.5*10^(-2) " Diameter of rod ";
parameter Real x (unit = " m ") = 0.1 " Distance of the point ";
parameter Real h (unit = "W/m^2 K") = 28.4 " Heat transfer coefficient between surface and air ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159275358979;

//=============
// Variable Section

Real m(unit = " ")  "Value of m";
Real k (unit = "W/ m K ") " Thermal Conductivity of the rod ";
Real a(unit= "m^2") " Area of the rod ";
Real p(unit= "m") " Perimeter of the rod ";

//=============
// Equation Section
equation

m=(log((T[2]-Tair)/(T[1]-Tair)))/(-1*x);
a=pi*d*d/4;
p=pi*d;
k=(h*p)/(m*m*a);

end Ex3_27;
//======================================================
