//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.8 Page 63
//Title: Thickness of Insulating Layer
//======================================================

model Ex3_8
//=============
// Parameter Section

parameter Real  T1(unit = " C ") =1200 " Inner Surface Temperature ";
parameter Real  T2(unit = " C ") = 15  " Outer Surface Temperature "; 
parameter Real  Q(unit = " W ") = 1450  " Heat loss per unit square meter ";
parameter Real  K1(unit = " W/m C ") = 1.4  " Thermal Conductivity of wall  ";
parameter Real  K2(unit = " W/m C ") = 0.35 " Thermal Conductivity of insulating material  ";
parameter Real  L1(unit = " m ") = 0.5 " Thickness of the wall ";


//=============
// Variable Section

Real  L2(unit = " m ") " Thickness of the wall ";

//=============
// Equation Section

equation

L2= (K2)*(((T1-T2)/Q)-(L1/K1));

end Ex3_8;
//======================================================
