//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.9 Page 64
//Title: Rate Of Heat Leakage
//======================================================

model Ex3_9
//=============
// Parameter Section

parameter Real  Ta(unit = " C ") = 30 " Ambient air temperature ";
parameter Real  Tb(unit = " C ") = -20  " Temperature in the room "; 
parameter Real  h(unit = " W/m^2 C ") = 23.26  " Heat transfer coefficient between glass and air ";
parameter Real  L1(unit = " m ") = 0.006 " Thickness of the glass sheets ";
parameter Real  L2(unit = " m ") = 0.002 " Thickness of the air gap ";
parameter Real  K1(unit = " W/m C ") = 0.75  " Thermal Conductivity of glass  ";
parameter Real  K2(unit = " W/m C ") = 0.02 " Thermal Conductivity of air  ";

//=============
// Variable Section

Real Q(unit= "W/m^2") " Heat Transfer Rate per unit area ";

//=============
// Equation Section

equation

Q= (Ta-Tb)/((2/h) + 2*(L1/K1) + (L2/K2));

end Ex3_9;
//======================================================
