//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.3 Page 164
//Title: Time taken
//======================================================

model Ex5_3
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real d(unit="m")=0.01 " Diameter of steel rod";
parameter Real L(unit="m")=1 " Length of steel rod";
parameter Real k(unit="W/mK")=40 " Thermal Conductivity";
parameter Real h(unit="W/m^2 K")=100 " Convective Heat transfer coefficient";
parameter Real c(unit="J/kg K")=460 " Specific heat";
parameter Real p1(unit="kg/m^3")=7800 " Density";
parameter Real To(unit="C")=320 " Uniform temperature";
parameter Real Ti(unit="C")=120 " Liquid temperature";
parameter Real T(unit="C")=200 " Rod temperature";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real A(unit="m^2") " Area";
Real V(unit="m^3") " Volume";
Real Lc(unit="m") " Corrected length";
Real Bi(unit="") " Biot No";
Real t(unit="s") " Time";

//=============
// Equation Section

equation

V=pi*d*d*L/4;
A=pi*d*L;
Lc=V/A;
Bi=h*Lc/k;
((T-Ti)/(To-Ti))=e^(-(h*A*t)/(p1*c*V));

end Ex5_3;
//======================================================
