//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.5 Page 166
//Title: Heat transfer coefficient
//======================================================

model Ex5_5
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real d(unit="m")=3e-2 " Thickness of slab";
parameter Real k(unit="W/mK")=370 " Thermal Conductivity";
parameter Real c(unit="J/kg K")=380 " Specific heat";
parameter Real p1(unit="kg/m^3")=9000 " Density";
parameter Real To(unit="C")=210 " Uniform temperature";
parameter Real Ti(unit="C")=100 " Liquid temperature";
parameter Real T(unit="C")=170 " Final temperature";
parameter Real t(unit="s")=300 " Time";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Lc(unit="m") " Corrected length";
Real h(unit="W/m^2 K") " Heat transfer coefficient";

//=============
// Equation Section

equation

2*Lc=d;
((T-Ti)/(To-Ti))=e^(-(h*t)/(p1*c*Lc));

end Ex5_5;
//======================================================
