//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-6: Fundamentals of Convective Heat Transfer
//Example: 6.9 Page 258
//Title: Pressure Drop
//======================================================

model Ex6_9
extends Modelica.Math;
//=============
// Parameter Section

parameter Real L (unit = " m ") = 100 " Length ";
parameter Real b(unit = " m ") = 2e-2 " Breadth of duct ";
parameter Real h (unit = " m ") = 2.5e-2 " Length of duct ";
parameter Real rho( unit = "kg/m^3 ")= 995 " Density of water ";
parameter Real v( unit = "m^2/s ")= 0.66e-6 " Kinematic viscosity of water ";
parameter Real u ( unit = "m/s") = 0.5 " Velocity of water ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real Dh( unit = "m") " Hydraulic Diameter ";
Real Re(unit = "") " Reynolds Number ";
Real hL(unit = " m ") " Head Loss ";
Real f(unit = "") " Friction factor in turbulent flow ";
Real P(unit = "Pa") "Pressure Drop ";

//=============
// Equation Section

equation

Dh=2*(b*h)/(b+h);
Re=u*Dh/v;
f=0.316*(Re^(-0.25));
hL=(f*L*u*u)/(2*9.81*Dh);
P=rho*9.81*hL;

end Ex6_9;
//======================================================
