//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.11 Page 298
//Title: Rate of heat transfer
//======================================================

model Ex7_11
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=25 " Velocity";
parameter Real T1(unit="C")=124 " Temperature of surface";
parameter Real T2(unit="C")=30 " Air Temperature";
parameter Real d(unit="m")=5e-2 " Dimension";

//Properties of air at film temperature 77C
parameter Real v1(unit = "m^2/s") = 2.092e-5 " Kinematic viscosity";
parameter Real Pr(unit="")=0.7 " Prandtl number";
parameter Real k(unit="W/m K")=3e-2 " Thermal conductivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Re(unit= "")" Reynolds no";
Real hc(unit= "W/m^2 K")" Heat transfer coefficient circular tube";
Real Nuc(unit= "")" Nusselt no circular tube";
Real Nus(unit= "")" Nusselt no square tube";
Real hs(unit= "W/m^2 K")" Heat transfer coefficient square tube";

//=============
// Equation Section

equation

Re=u*(d/v1);
Nuc=hc*d/k;
Nuc=0.027*(Re^0.805)*Pr^(1/3);
Nus=hs*d/k;
Nus=0.102*(Re^0.675)*Pr^(1/3);

end Ex7_11;
//======================================================
