//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.12 Page 302
//Title: Heat transfer coefficient and pressure drop
//======================================================

model Ex7_12
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=6 " Velocity";
parameter Real T1(unit="C")=70 " Temperature of surface";
parameter Real T2(unit="C")=15 " Air Temperature";
parameter Real d(unit="m")=16.4e-3 " Dimension";
parameter Real ST(unit="m")=0.0205 " Transverse Pitch";
parameter Real SL(unit="m")=0.0205 " Longitudinal Pitch";
parameter Real N(unit="")=7 " No of rows";

//Properties of air at film temperature 42.5C
parameter Real v1(unit = "m^2/s") = 17.4e-6 " Kinematic viscosity";
parameter Real Pr(unit="")=0.705 " Prandtl number";
parameter Real k(unit="W/m K")=0.0274 " Thermal conductivity";
parameter Real p1(unit="kg/m^3")=1.217 " Density";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real umax(unit="m/s")" Velocity";
Real Remax(unit= "")" Reynolds no";
Real h(unit= "W/m^2 K")" Heat transfer coefficient circular tube";
Real Nu(unit= "")" Nusselt no ";
Real dP(unit="Pa") "Pressure drop";

//=============
// Equation Section

equation

umax=u*ST/(ST-d);
Remax=umax*(d/v1);
Nu=h*d/k;
Nu=1.13*(0.518)*(0.97)*(Remax^0.556)*(Pr^(1/3));
dP=N*0.4*1.04*0.5*(p1*umax*umax);//Values of f and g taken from fig7.10 on pg303

end Ex7_12;
//======================================================
