//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.14 Page 305
//Title: Convective heat transfer coefficient
//======================================================

model Ex7_14
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real V(unit="m^3/s")=0.314 " Volumetric flow rate";
parameter Real T1(unit="C")=96 " Temperature of surface";
parameter Real T2(unit="C")=200 " Air Temperature";
parameter Real D(unit="m")=1.9e-2 " Outer Diameter";
parameter Real L(unit="m")=1.25 " Length of tube";
parameter Real ST(unit="m")=28.6e-3 " Transverse Pitch";
parameter Real SL(unit="m")=38e-3 " Longitudinal Pitch";
parameter Real N1(unit="")=7 " No of tubes in direction of flow";
parameter Real N2(unit="")=8 " No of tubes in perpendicular direction of flow";

//Properties of air at film temperature 148C
parameter Real v1(unit = "m^2/s") = 3e-5 " Kinematic viscosity";
parameter Real Pr(unit="")=0.688 " Prandtl number";
parameter Real k(unit="W/m K")=39e-3 " Thermal conductivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real umax(unit="m/s")" Velocity";
Real Remax(unit= "")" Reynolds no";
Real h(unit= "W/m^2 K")" Heat transfer coefficient circular tube";
Real Nu(unit= "")" Nusselt no";
Real Nuc(unit= "")" Nusselt no corrected";

//=============
// Equation Section

equation

umax=V/((ST*N2*L)-(D*N2*L));
Remax=umax*(D/v1);
Nuc=h*D/k;
Nu=0.299*(Remax^0.602)*(Pr)^(1/3);
Nuc=0.96*Nu;

end Ex7_14;
//======================================================
