//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.19 Page 314
//Title: Hausen & Sieder-Tate correlation
//======================================================

model Ex7_19
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real m(unit="m^3/s")=10e-6 " Flow rate";
parameter Real Ts(unit="C")=60 " Temperature of surface";
parameter Real Tw[2](unit="C")={20,34} " Water temperatures at inlet and at length 1m";
parameter Real D(unit="m")=15e-3 " Diameter";
parameter Real L(unit="m")=1 " Length";

//Property values of water at 27C
parameter Real v1(unit="Pa s")=855e-6 " Viscosity";
parameter Real k(unit="W/mK")=613e-3 " Thermal conductivity";
parameter Real Pr(unit="")=5.83 " Prandtl No";
parameter Real p1(unit="kg/m^3")=997 " Density";
parameter Real Cp(unit="J/kgK")=4180 " Specific heat";
parameter Real v2(unit="Pa s")=464e-6 " Viscosity at 60C";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Nu1(unit="")" Nusselt no from Hausen correlation";
Real Nu2(unit="")" Nusselt no from Sieder-Tate correlation";
Real u(unit="m/s")" Velocity";
Real Re(unit="")" Reynolds No";

//=============
// Equation Section

equation

u=4*m/(pi*D*D);
Re=p1*D*u/v1;
Nu1=3.66 + ((0.068*(D/L)*Re*Pr)/(1 + 0.04*((D/L)*Re*Pr)^(2/3)));
Nu2=1.86 *(Re*Pr*D/L)^(1/3) * (v1/v2)^(0.14);

end Ex7_19;
//======================================================
