//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.23 Page 320
//Title: Average heat transfer coefficient
//======================================================

model Ex7_23
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=80e-2 " Velocity";
parameter Real Ts(unit="C")=200 " Temperature of surface";
parameter Real Tw(unit="C")=147 " Water average temperature";
parameter Real D(unit="m")=50e-3 " Diameter";
parameter Real L(unit="m")=2 " Length";

//Property values of water at 147C
parameter Real v1(unit="m^2/s")=6.94e-6 " Kinematic Viscosity";
parameter Real k(unit="W/mK")=0.133 " Thermal conductivity";
parameter Real Pr(unit="W/mK")=103 " Prandtl No";
parameter Real p1(unit="kg/m^3")=812.1 " Density";
parameter Real Cp(unit="J/kgK")=2427 " Specific heat";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Nu(unit="")" Nusselt no";
Real h(unit="W/m^2 K")" Heat transfer coefficient";
Real Re(unit="")"Reynolds No";

//=============
// Equation Section

equation

Re=u*D/v1;
Nu=0.036*(Re^0.8)*(Pr^(1/3))*((D/L)^(0.055));
Nu=h*D/k;

end Ex7_23;
//======================================================
