//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.24 Page 321
//Title: Heat leakage
//======================================================

model Ex7_24
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=7 " Velocity";
parameter Real Ts(unit="C")=20 " Temperature of air";
parameter Real D[2](unit="m")={0.4,0.8} " Dimensions ";
parameter Real v1(unit="m^2/s")=15.06e-6 " Kinematic Viscosity";
parameter Real k(unit="W/mK")=0.0259 " Thermal conductivity";
parameter Real a1(unit="m^2/hour")=7.71e-2 " Thermal diffusivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Dh(unit="m")" Hydraulic diameter";
Real h(unit="W/m^2 K")" Heat transfer coefficient";
Real Re(unit="")" Reynolds No";
Real Nu(unit="")" Nusselt No";
Real Pr(unit="")" Prandtl No";
Real Q(unit="W")" Heat leakage per unit temperature difference";

//=============
// Equation Section

equation

Dh=4*D[1]*D[2]/(2*(D[1]+D[2]));
Re=u*Dh/v1;
Pr=v1/(a1/3600);
Nu=h*Dh/k;
Nu=0.023*(Re^0.8)*(Pr^0.4);
Q=h*2*(D[1]+D[2]);

end Ex7_24;
//======================================================
