//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.3 Page 282
//Title: Boundary layer thickness and total drag force
//======================================================

model Ex7_3
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x[2](unit = "m") = {0.3,0.8} " Distance of plane from the plate  ";
parameter Real u(unit="m/s")=3 " Velocity";
parameter Real T(unit="C")=20 " Temperature";
parameter Real l[2](unit="m")={2,1} " Dimensions";
parameter Real Rec(unit= "")=5e5" Reynolds no";

//Properties of air at 20C
parameter Real v1(unit = "m^2/s") = 15e-6 " Kinematic viscosity";
parameter Real p1(unit = "kg/m^3") = 1.17 " Density";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Re(unit= "")" Reynolds no";
Real xc(unit= "m")" Critical length";
Real d(unit= "m")" Boundary layer thickness";
Real Cfx(unit= "")" Skin friction ";
Real d30(unit= "m")" Boundary layer thickness at 0.3m";
Real d80(unit= "m")" Boundary layer thickness at 0.8m";
Real T1(unit="N/m^2")" Shear stress";
Real F(unit="N")" Drag Force";
Real m(unit= "kg/s")" Mass flow rate of air";

//=============
// Equation Section

equation

Rec=xc*u/v1;
Re=l[1]*u/v1;
d=4.64*2/(Re^0.5);
Cfx=1.292/(Re^0.5);
T1=1.292*(0.5*p1*u*u)*(Re^(-0.5));
F=2*l[1]*l[2]*T1;
d30=(4.64*0.3)/(u*0.3/v1)^0.5;
d80=(4.64*0.8)/(u*0.8/v1)^0.5;
m=(5/8)*(p1*u*(d80-d30));

end Ex7_3;
//======================================================
