//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.5 Page 286
//Title: Drag force 
//======================================================

model Ex7_5
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=8 " Velocity";
parameter Real T1(unit="C")=78 " Temperature of plate";
parameter Real T2(unit="C")=250 " Air Temperature";
parameter Real l[2](unit="m")={0.3,1} " Dimensions";
parameter Real P(unit="Pa")=8e3 "Pressure ";

//Properties of air at film temperature 164C, 1 atm
parameter Real v1(unit = "m^2/s") = 30.8e-6 " Kinematic viscosity";
parameter Real Cp(unit = "kJ/kgK") = 1.018 " Specific heat capacity";
parameter Real Pr(unit="")=0.69 " Prandtl number";
parameter Real k(unit="W/m K")=36.4e-3 " Thermal conductivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real p1(unit="kg/m^3") "Density";
Real Re(unit= "")" Reynolds no";
Real v2(unit= "m^2/s")" New kinematic viscosity";
Real h(unit= "W/m^2 K")" Heat transfer coefficient";
Real F(unit="N")" Drag Force";
Real Ts(unit="N/m^2")" Shear stress";
Real Cfx(unit= "")" Skin friction ";
Real St(unit= "")" Stanton no";

//=============
// Equation Section

equation

v1/v2=P/(1.01325e5);
Re=l[2]*u/v2;
h=0.662*(k/l[2])*(Re^0.5)*(Pr^(1/3));
St=h/(p1*Cp*1e3*u);
p1=P/(287*437);
St*Pr^(2/3)=Cfx/2;
Ts=(p1*u*u)*(Cfx/2);
F=2*Ts*l[1]*l[2];

end Ex7_5;
//======================================================
