//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.6 Page 289
//Title:  Thickness of boundary layer and heat transfer coefficient
//======================================================

model Ex7_6
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=80 " Velocity";
parameter Real T(unit="C")=10 " Air Temperature";
parameter Real l[2](unit="m")={1,1} " Dimensions";

//Properties of air at 10C
parameter Real v1(unit = "m^2/s") = 14.15e-6 " Kinematic viscosity";
parameter Real Pr(unit="")=0.72 " Prandtl number";
parameter Real k(unit="W/m K")=25e-3 " Thermal conductivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Nu(unit= "")" Nusselt no";
Real Re(unit= "")" Reynolds no";
Real d(unit= "m")" Boundary layer thickness";
Real h(unit= "W/m^2 K")" Heat transfer coefficient";

//=============
// Equation Section

equation

Re=l[1]*u/v1;
d=0.381*l[1]*Re^(-0.2);
Nu=0.037*(Re^0.8)*(Pr^(1/3));
h=Nu*k/l[1];

end Ex7_6;
//======================================================
