//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.9 Page 297
//Title: Heat transfer rate and power loss 
//======================================================

model Ex7_9
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=0.3 " Velocity";
parameter Real T1(unit="C")=127 " Temperature of bulb";
parameter Real T2(unit="C")=27 " Air Temperature";
parameter Real d(unit="m")=60e-3 " Bulb diameter";
parameter Real P(unit="W")=100 " Power rating ";

//Properties of air at film temperature 77C
parameter Real v1(unit = "m^2/s") = 2.08e-5 " Kinematic viscosity";
parameter Real Pr(unit="")=0.697 " Prandtl number";
parameter Real k(unit="W/m K")=0.03 " Thermal conductivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Re(unit= "")" Reynolds no";
Real h(unit= "W/m^2 K")" Heat transfer coefficient";
Real Nu(unit= "")" Nusselt no";
Real Q(unit= "W")" Heat transfer rate";
Real loss(unit= "")" Loss percentage";

//=============
// Equation Section

equation

Re=u*(d/v1);
Nu=h*d/k;
Nu=0.37*(Re^0.6);
Q=h*d*d*pi*(T1-T2);
loss=Q*100/100;

end Ex7_9;
//======================================================
