//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.15 Page 359
//Title: Heat transfer rate in concentric spheres
//======================================================

model Ex8_15
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real d[2] (unit = " m ") = {0.15,0.2} " Respective diameter of the spheres ";
parameter Real T[2]( unit = " K ")= {275,325} " Temperatures of inner and outer spheres respectively";
parameter Real P( unit = " atm ")= 3 " Air pressure ";
parameter Real R( unit = " J/mol K ")= 8.314 " Universal Gas Constant ";
parameter Real M( unit = " kg ")= 28.8e-3 " Molecular Mass of air ";

//Surface properties at 300 kelvin

parameter Real k (unit = " W/m K ") = 26.3e-3 " Thermal Conductivity of air ";
parameter Real u (unit = " kg/m s ") = 18.46e-6 " Viscosity of air ";
parameter Real Pr( unit = "") =0.707 " Prandtl Number ";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real l (unit = " m ") " Length";
Real d1 (unit = " kg/m^3 ") " Density of air ";
Real B (unit = " K^-1 ") " Volumetric Coefficient of air ";
Real Tf(unit = " C") " Film Temperature ";
Real v1 (unit = " m^2/s ") " Kinematic Viscosity of air ";
Real ke (unit = " W/m K ")  " Effective Thermal Conductivity of air ";
Real Ra(unit ="") " Rayleigh Number ";
Real Ra1(unit ="") " Modified Rayleigh Number ";
Real Q(unit = " W") " Heat Loss";

//=============
// Equation Section

equation

l=(d[2]-d[1])/2;
Tf=(T[1]+T[2])/2;
d1=(P*1.01325e5*M)/(R*Tf);
v1=u/d1;
B=1/(Tf);
Ra= ((g_n*B*(l^3)*(T[2]-T[1]))*Pr)/(v1^2);
Ra1=((l/(d[2]*d[1])^4)* ( Ra /( (d[2]^(-1.4)) + (d[1]^(-1.4)) )^5))^0.25;
ke=0.74*k*((Pr/(Pr+0.861))^0.25)*(Ra1^0.25);
Q=pi*ke*d[1]*d[2]*(T[2]-T[1])/l;

end Ex8_15;
//======================================================
