//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.4 Page 344
//Title: Convective Heat Loss
//======================================================

model Ex8_4
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real L (unit = "m ") = 1 " Length of the radiator ";
parameter Real w (unit = "m ") = 0.5 " Width of the radiator ";
parameter Real T[2]( unit = "C ")= {20,84} " Temperatures of air and plate ";

//Surface properties at 52 degree celsius
parameter Real k (unit = "W/m C ") = 28.15e-3 " Thermal Conductivity of air ";
parameter Real v1 (unit = "m^2/s ") = 18.41e-6 " Kinematic Viscosity of air ";
parameter Real Pr (unit = "") = 0.7 " Prandtl Number ";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tf( unit = "C") " Film Temperature ";
Real B (unit = "K^-1 ") " Volumetric Coefficient of air ";
Real Gr( unit = "") " Grashoff Number ";
Real Ra( unit = "") " Rayleigh Number ";
Real Nu( unit = "") " Nusselt Number ";
Real h(unit = "W/m^2 C") " Average heat transfer coefficient ";
Real Q(unit = "W") " Rate of heat loss ";

//=============
// Equation Section

equation

Tf=(T[1]+T[2])/2;
B=1/(Tf+273);
Gr= (g_n*B*(L^3))*(T[2]-T[1])/(v1^2);
Ra=Gr*Pr;
Nu=(0.825+((0.387*Ra^(1/6))/(1+(0.492/Pr)^(9/16))^(8/27)))^2;
h=Nu*k/L;
Q=h*w*L*(T[2]-T[1]);

// There is an error in computation of Nu. The correct value of Nu is 188.5

end Ex8_4;
//======================================================
