//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.6 Page 346
//Title: Heat gained by the duct
//======================================================

model Ex8_6
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real L (unit = " m ") = 0.3 " height of the duct";
parameter Real w (unit = " m ") = 0.6 " Width of the duct";
parameter Real T[2]( unit = " C ")= {15,25} " Temperatures of surface and air";

//Surface properties at 20 degree celsius
parameter Real B (unit = " K^-1 ")=3.41e-3" Volumetric Coefficient of water ";
parameter Real k (unit = " W/m C ") = 25.93e-3 " Thermal Conductivity of water ";
parameter Real v1 (unit = " m^2/s ") = 15.06e-6 " Kinematic Viscosity of water ";
parameter Real Pr( unit = "") =0.705 " Prandtl Number ";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section


Real Tf(unit = "C") " Film Temperature ";
Real Ra( unit = "") " Rayleigh Number ";
Real Nu( unit = "") " Nusselt Number ";
Real hv(unit = "W/m^2 C") " Average heat transfer coefficient on vertical side ";
Real hu(unit = "W/m^2 C") " Average heat transfer coefficient on upper surface ";
Real hl(unit = "W/m^2 C") " Average heat transfer coefficient on lower surface ";
Real Q(unit = "W/m") " Rate of heat gained";

//=============
// Equation Section

equation

Tf=(T[1]+T[2])/2;
Ra= (g_n*B*(L^3))*(T[2]-T[1])*Pr/(v1*v1);
Nu=0.59*(Ra^0.25);
hv=Nu*k/L;
hu=0.15*(Ra^(1/3))*k/L;
hl=0.27*(Ra^(1/4))*k/L;
Q=((2*hv*L)+(hu+hl)*w)*(T[2]-T[1]);

end Ex8_6;
//======================================================
