//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-9: Thermal Radiation-Basic Relations
//Example: 9.1 Page 378
//Title: Solar Radiation
//======================================================

model Ex9_1
extends Modelica.Math;
//=============
// Parameter Section

parameter Real L (unit = " km ") = 1.5e8 " Distance between earth and sun ";
parameter Real D (unit = " km ") = 1.39e6 " Diameter of the Sun ";
parameter Real T( unit = " C ")= 5527 " Temperature of the sun ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real Q( unit = "W/m^2 ")" Solar radiation from the sun ";

//=============
// Equation Section

equation

Q=0.25*(sigma*(T+273)^4)*((D*D)/(L*L));

end Ex9_1;
//======================================================
