//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-9: Thermal Radiation-Basic Relations
//Example: 9.3 Page 384
//Title: Average hemispherical Transmissivity
//======================================================

model Ex9_3
extends Modelica.Math;
//=============
// Parameter Section

parameter Real l[2] (unit = " micro m ") = {0.3,3} " Wavelengths ";
parameter Real T(unit = " K ")= 5555 " Temperature of the black body ";
parameter Real t(unit = "") = 0.8 "Transmissivity of glass in the range 0.4 to 3 micrometre wavelength range";
parameter Real F[3](unit = "")={0,0.10503,0.97644} "Fractional Emissive power from Table 9.2 on page 385 ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real t1(unit = "")" Average hemispherical transmissivity ";
Real C[2](unit = "micro K")" Wavelength * Temperature ";

//=============
// Equation Section

algorithm
for i in 1:2 loop
C[i]:= (T*l[i]);
end for;

equation
t1=t*(F[3]-F[2]);

end Ex9_3;
//======================================================
