//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-9: Thermal Radiation-Basic Relations
//Example: 9.8 Page 391
//Title: Energy Absorbed
//======================================================

model Ex9_8
extends Modelica.Math;
//=============

// Parameter Section

parameter Real T(unit = " K ")= 5555 " Temperature of the black body ";
parameter Real e1(unit = "") = 0.3 " Emissivity within 3 micrometer ";
parameter Real e2(unit = "") = 0.9 " Emissivity beyond 3 micrometer ";
parameter Real t(unit = "") = 0.8 " Transmissivity ";
parameter Real F[3](unit = "")={0,0.10503,0.97644} " Fractional Emissive power from Table 9.2 on page 385";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 " Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section
Real Eb(unit = "MW/m^2")" Total emissive power ";
Real i(unit = "MW/m^2")" Total incident radiation ";
Real tr(unit = "MW/m^2")" Total radiation transmitted";
Real a[3](unit = "MW/m^2")" Radiation absorbed ";
Real ta(unit = "MW/m^2")" Total Radiation absorbed ";

//=============
// Equation Section

equation

Eb=sigma*(T^4)/(1e6);
i= Eb*(F[3]-F[2]);
tr=i*t;
a[1]=(e1*i);//for 0.4 to 3 micrometers
a[2]=(e1*Eb*(F[2]-F[1]));//for 0 to 0.4 micrometers
a[3]=(e2*Eb*(1-F[3])); //beyond 3 micrometers
ta=a[1]+a[2]+a[3];

//The answer is incorrect as temperature is taken as 5780K but is actually 5555K in Ex9.3,hence there is a variation in the answer.

end Ex9_8;
//======================================================
