//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-1: Basic Concepts
//Example: 1.1 Page 9
//Title: Heat Transferred per unit area
//======================================================

model Ex1_1
//=============
// Parameter Section

parameter Real L(unit = "m") = 0.02 " Thickness of the plate";
parameter Real T[2](unit = "C") = {550,50} " Temperatures of the edge";
parameter Real k(unit = "W/m C") = 19.1 " Thermal Conductivity of the plate at 300 celsius";

//=============
// Variable Section

Real Q(unit= "kW/m^2") " Heat Transfer Rate";

//=============
// Equation Section

equation

Q= (k*(T[1]-T[2]))/(1000*L);

end Ex1_1;
//======================================================
