//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-1: Basic Concepts
//Example: 1.3 Page 11
//Title: Basic Radiative Heat Transfer
//======================================================

model Ex1_3
//=============
// Parameter Section

parameter Real T(unit = "C") = 55 " Surface Temperature ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 " Stefan Boltzmann Constant";
    
//=============
// Variable Section

Real Q(unit= "kW/m^2") " Heat Transfer Rate";

//=============
// Equation Section

equation


Q= sigma*((T+273)^4)/1000;

end Ex1_3;
//======================================================
