//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-1: Basic Concepts
//Example: 1.5 Page 20
//Title: Overall Heat Transfer Coefficient
//======================================================

model Ex1_5
//=============
// Parameter Section

parameter Real l(unit = "m") = 0.145 " Length of the wall";
parameter Real k(unit = "W/ m C") = 0.145 " Thermal Conductivity of the wall";
parameter Real e(unit = " ") = 0.85 " Emissivity of wall ";
parameter Real Tg(unit = "K") = 1073 " Gas Temperature ";
parameter Real Twg(unit = "K") = 1071 " Wall Temperature on gas side ";
parameter Real hg(unit = "W/m^2 C") = 40 " Film Conductance on gas side ";
parameter Real hc(unit = "W/m^2 C") = 10 " Film Conductance on coolant side ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 " Stefan Boltzmann Constant";
parameter Real f(unit = " ") = 1 " Radiation shpae factor between wall and gas ";

     
//=============
// Variable Section

Real U(unit= "W/m^2 C") " Overall Heat Transfer Coefficient";
Real R1(unit= "m^2/W") " Heat Transfer Resistance 1";
Real R2(unit= "m^2/W") " Heat Transfer Resistance 2";
Real R3(unit= "m^2/W") " Heat Transfer Resistance 3";


//=============
// Equation Section

equation

R1= ((1/hc)+((e*f*sigma*(Tg^4-Twg^4))/(Tg-Twg)))^(-1) ;
R2= l/k;
R3= 1/hc;
U=1/(R1+R2+R3);

end Ex1_5;
//======================================================
//Error in R1 value:
//Value of R1 is mentioned as 3.6E-3. 
//Actual value of R1 is 4.2E-3. Answer of U is however 0.9056 W/m2 K
