//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.16 Page 430
//Title: Radiant heat exchange
//======================================================

model Ex10_16
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=1796 " Temperature of furnace";
parameter Real T2(unit="K")=310 " Temperature of wall";
parameter Real A2(unit="m^2")=2 " Area";
parameter Real A3(unit="m^2")=4 " Area";
parameter Real A4(unit="m^2")=12 " Area";
parameter Real A5(unit="m^2")=8 " Area";
parameter Real e(unit="")=0.8 " Emissivity ";
parameter Real a(unit="m")=0.04 " Opening area";

//Values of shape factors obtained from Fig 10.3 on pg 409
parameter Real F12(unit="")=0.033 " Shape factor";
parameter Real F13(unit="")=0.05 " Shape factor";
parameter Real F14(unit="")=0.12 " Shape factor";
parameter Real F15(unit="")=0.08 " Shape factor";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real F0w(unit="") " Shape factor";
Real Q(unit="kW")" Heat transferred";

//=============
// Equation Section

equation

F0w=F12+F13+F14+F15;
Q=e*sigma*a*F0w*((T1^4)-(T2^4))/1000;

end Ex10_16;
//======================================================
