//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.19 Page 433
//Title: Radiation heat transfer
//======================================================

model Ex10_19
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=300 " Temperature of outer wall";
parameter Real T2(unit="K")=120 " Temperature of inner wall";
parameter Real D(unit="m")=21e-2 " Inner Diameter";
parameter Real D1(unit="m")=30e-2 " Outer Diameter";
parameter Real e(unit="")=0.03 " Emissivity of silver";
parameter Real rv(unit="kJ/kg")=220 " Rate of vapourisation";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q12(unit="W")" Heat loss";
Real ee(unit="")" Equivalent Emissivity ";
Real A(unit="m^2")" Area";
Real r(unit="kg/hour")" Rate of evaporation";

//=============
// Equation Section

equation

Q12=sigma*ee*(A)*((T1^4)-(T2^4));
(1/ee)=(1/e)+(((D/D1)^2)*((1/e) - 1));
A=4*pi*D*D;
r=Q12*3600/(rv*1000);

end Ex10_19;
//======================================================
